//
//  GSCustomParameter.h
//  GlyphsCore
//
//  Created by Georg Seifert on 30.11.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <GlyphsCore/GSBase.h>
#import <GlyphsCore/GSContainerProtocol.h>
#if !defined(GLYPHS_LITE) && !defined(LIBCORE)
#import <GlyphsCore/GSIdentifiableParameter.h>
#endif

NS_ASSUME_NONNULL_BEGIN

@class GSInstance;
@protocol GSContainerProtocol;
@class GSFont;

extern NSString *const GSCustomParametersIdentifier;
extern NSString *const GSCustomParametersKey;

/** Implementation of the Custom Property object.

 It stores a name/value pair
 */
#if !(defined(GLYPHS_LITE) || defined(LIBCORE))
@interface GSCustomParameter : NSObject <GSIdentifiableParameter, GSItemProtocol>
#else
@interface GSCustomParameter : NSObject <GSItemProtocol>
#endif

- (instancetype)initWithName:(NSString *)name value:(id)value;

@property (nonatomic, strong) NSString *name;

@property (nonatomic, strong) id value;

@property (nonatomic, strong) id valueUI;

@property (nonatomic, assign) BOOL active;

@property (nonatomic, readonly) BOOL validated;

#ifndef GLYPHS_VIEWER
/// Replaces single quotes with tick marks and removes all non-ASCII characters.
- (NSString *)saveValue;

#endif

+ (nullable NSColor *)colorFromValue:(id)value;
/** If the property stores a color, this returns a NSColor object

 It converts a comma separated list of strings into a color. e. g. 63,165,53 will be green
 @return a NSColor object
 */
@property (nonatomic, strong) NSColor *colorValue;

- (void)validateValue;

+ (nullable id)defaultValueForKey:(nonnull NSString *)name object:(nonnull GSFont *)object;

- (void)postRead:(GSFormatVersion)formatVersion;

#ifndef GLYPHS_VIEWER
- (void)validateValueFormat:(GSFormatVersion)formatVersion;

+ (NSArray *)validateNameList:(NSArray *)parameter;

- (id)propertyListValueFormat:(GSFormatVersion)formatVersion;
#endif

+ (id)propertyListValueForColor:(NSColor *)color format:(GSFormatVersion)formatVersion;

#ifndef GLYPHS_VIEWER
- (nullable NSString *)displayValue;
#endif

- (id)contentValue;

- (NSString *)stringValue;

- (BOOL)boolValue;

- (float)floatValue;

- (NSInteger)integerValue;

- (int)intValue;

#ifndef GLYPHS_VIEWER
#ifndef GLYPHS_LITE
- (CGFloat)localizedValueForScript:(NSString *)script;

- (id)valueAsPropertyListValueFormat:(GSFormatVersion)formatVersion quotesIfNeeded:(BOOL)quotes;

+ (nullable id)infoPropertyForKeys:(nonnull NSArray *)keys fromObjects:(nonnull NSArray *)objects;

+ (nullable GSCustomParameter *)customParameterForKeys:(nonnull NSArray *)keys fromObjects:(nonnull NSArray *)objects;

#ifndef LIBCORE
+ (BOOL)convertParameterToProperties:(NSMutableArray *)parameters object:(GSFont *)object error:(NSError **)error;

+ (void)makeIdentifiers:(NSArray *)parameters;
#endif
#endif
#endif

- (void)setValueFast:(id)value;

#ifndef GLYPHS_VIEWER
- (void)setParameterIdentifier:(NSString *)parameterIdentifier;
#endif

@end

NS_ASSUME_NONNULL_END
